import { Text, View, ScrollView, TouchableOpacity, StyleSheet } from "react-native";
import React from "react";
import moment from "moment";
import { useNavigation } from "@react-navigation/native";
import BackNavigation from "../Utilities/CustomHeader/BackNavigation";
import dpr from "../Utilities/CustomStyleAttribute/dpr";

import { trackOrderStyle } from "./trackOrderStyle";
import CommonStyles from "../Utilities/CommonStyles/CommonStyles";
import { OrderDetailsStyle } from "../Profile/OrderHistory/OrderDetails/OrderDetailsStyle";
import useAuth from "../../hooks/useAuth";
import useProcessPrice from "../../hooks/useProcessPrice";
import useLangTranslation from "../../hooks/useLangTranslation";
import { PRODUCT_DETAILS } from "../../components/Navigation/RouteNames";
import { Pressable } from "react-native";

const TrackOrder = (props) => {
    const navigation = useNavigation();
    const { trans } = useLangTranslation();
    const { user } = useAuth();
    const processPrice = useProcessPrice();
    const { myTrackOrders = {} } = props?.route?.params;
    const {
        total = 0,
        status = "",
        order_key = "",
        created_at = "",
        payment_status = "",
        line_items = [],
    } = myTrackOrders;


    const styles = Styles(line_items);

    return (
        <>
            <BackNavigation
                navigationProps={props.navigation}
                routeName={trans("track order")}
                capitalize={true}
            />
            <View style={trackOrderStyle.hrLine} />
            <>
                <ScrollView
                    showsVerticalScrollIndicator={false}
                    style={CommonStyles.cont}
                >
                    <View style={CommonStyles.globalContainer}>
                        <View style={trackOrderStyle.topPosition}>
                            <Text style={trackOrderStyle.topText1}>
                                {trans("Order Reference")}
                            </Text>
                            <Text style={trackOrderStyle.topText2}>
                                {order_key}
                            </Text>
                        </View>
                        {!user && (
                            <View style={trackOrderStyle.moreDetailsContainer}>
                                <Text style={trackOrderStyle.moreDetailsText}>
                                    {trans("For more details, please")}{" "}
                                </Text>
                                <TouchableOpacity
                                    onPress={() => {
                                        props.navigation.navigate("login");
                                    }}
                                >
                                    <Text style={trackOrderStyle.login}>
                                        {trans("login to your account.")}
                                    </Text>
                                </TouchableOpacity>
                            </View>
                        )}
                        <View style={OrderDetailsStyle.deliveryCont}>
                            <View style={OrderDetailsStyle.deliverySubCont}>
                                <Text style={OrderDetailsStyle.deliveryText1}>
                                    {trans("Order Date")}
                                </Text>
                                <Text style={OrderDetailsStyle.deliveryText2}>
                                    {moment(created_at, "DD/MM/YYYY").format(
                                        "YYYY-MM-DD"
                                    )}
                                </Text>
                            </View>
                            <View
                                style={[
                                    OrderDetailsStyle.deliverySubCont,
                                    trackOrderStyle.deliverySubCont,
                                ]}
                            >
                                <Text style={OrderDetailsStyle.deliveryText1}>
                                    {trans("Status")}
                                </Text>
                                <Text style={OrderDetailsStyle.deliveryText2}>
                                    {trans(status)}
                                </Text>
                            </View>
                        </View>
                        <View
                            style={[
                                OrderDetailsStyle.deliveryCont,
                                trackOrderStyle.deliveryContainer,
                            ]}
                        >
                            <View style={OrderDetailsStyle.deliverySubCont}>
                                <Text style={OrderDetailsStyle.deliveryText1}>
                                    {trans("Payment Status")}
                                </Text>
                                <Text style={OrderDetailsStyle.deliveryText2}>
                                    {trans(payment_status)}
                                </Text>
                            </View>
                            <View
                                style={[
                                    OrderDetailsStyle.deliverySubCont,
                                    trackOrderStyle.deliverySubCont
                                ]}
                            >
                                <Text style={OrderDetailsStyle.deliveryText1}>
                                    {trans("Total")}
                                </Text>
                                <Text style={OrderDetailsStyle.deliveryText2}>
                                    {processPrice(total)}
                                </Text>
                            </View>
                        </View>
                        <View style={OrderDetailsStyle.orderProductsCont}>
                            <Text style={OrderDetailsStyle.orderProductTitle}>
                                {trans("Ordered Products")}
                            </Text>
                            {line_items?.map((item, index) => (
                                <Pressable
                                    onPress={() => {
                                        navigation.navigate(PRODUCT_DETAILS, {
                                            slug: item?.slug,
                                            item
                                        });
                                    }}
                                    key={`key` + index}
                                >
                                    <View
                                        style={[
                                            OrderDetailsStyle.singleProductCont,
                                            styles.singleProductContainer(index)
                                        ]}
                                    >
                                        <View>
                                            <Text
                                                style={OrderDetailsStyle.name}
                                            >
                                                {item?.name.length > 25
                                                    ? `${item.name.slice(
                                                          0,
                                                          25
                                                      )} ...`
                                                    : item.name}
                                            </Text>
                                            <View
                                                style={OrderDetailsStyle.items}
                                            >
                                                <Text
                                                    style={
                                                        OrderDetailsStyle.quantity
                                                    }
                                                >
                                                    {item?.quantity} x {trans("Item")}
                                                </Text>
                                                <View
                                                    style={
                                                        OrderDetailsStyle.vrLine
                                                    }
                                                />
                                                <Text
                                                    style={
                                                        OrderDetailsStyle.quantity
                                                    }
                                                >
                                                    {item?.vendor?.shop?.name}
                                                </Text>
                                            </View>
                                        </View>
                                        <View>
                                            <Text
                                                style={OrderDetailsStyle.name}
                                            >
                                                {processPrice(
                                                    parseInt(item?.price) *
                                                        parseInt(item?.quantity)
                                                )}
                                            </Text>
                                        </View>
                                    </View>
                                </Pressable>
                            ))}
                        </View>
                    </View>
                </ScrollView>
            </>
        </>
    );
};

export default TrackOrder;

const Styles = (line_items) => StyleSheet.create({
    singleProductContainer: (index) => ({
        borderBottomWidth:
            index ===
            line_items?.length - 1
                ? 0
                : 1,
        paddingBottom:
            index ===
            line_items?.length - 1
                ? dpr(12)
                : dpr(12),
        marginBottom:
            index ===
            line_items?.length - 1
                ? 0
                : dpr(12),
    })
});
